<?php

namespace App\Http\Controllers;

use App\Http\Requests\IncomeRequest;
use App\Models\Income;
use Auth;
use Illuminate\Http\Request;

class IncomeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        if ($request->has('search')) {
            $keyword = $request->input('search');
            $paginate = false;
            $incomes = Income::where('name', 'LIKE', '%' . $keyword . '%')
                ->with('transaction')
                ->orderBy('id', 'DESC')->get();

            return view('income.list', compact('incomes', 'paginate'));
        } else {
            $paginate = true;
            $incomes = Income::with('transaction')->orderBy('id', 'DESC')->paginate(10)->onEachSide(0);
            return view('income.list', compact('incomes', 'paginate'));
        }
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        return view('income.create');
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(IncomeRequest $request)
    {
        $income = new Income();
        $income->name = $request->input('name');
        $income->save();

        $income->transaction()->create([
            'amount' => (double) $request->input('amount'),
            'fee' => 0,
            'dr_cr' => 'cr',
            'date' => $request->input('date'),
            'method' => 'online',
            'note' => $request->input('description'),
            'created_user_id' => Auth::user()->id,
            'type' => 'income'
        ]);

        return back()->with('success', 'Saved successfully');
    }
    
    /**
     * Show the form for editing the specified resource.
     */
    public function edit(Income $income)
    {
        return view('income.edit', compact('income'));
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(IncomeRequest $request, Income $income)
    {
        $income = Income::find($income->id);
        $income->name = $request->input('name');
        $income->save();

        $income->transaction()->update([
            'amount' => (double) $request->input('amount'),
            'date' => $request->input('date'),
            'note' => $request->input('description'),
        ]);

        return redirect()->route('income.index')->with('success', 'Updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Income $income)
    {
        $income->delete();
        $income->transaction->delete();
        return redirect()->route('income.index')->with('success', 'Deleted successfully');
    }
}